package ru.yandex.chemodan.app.telemost.appmessages.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.misc.lang.DefaultObject;

@Getter
public class SetPeerStateRequest extends DefaultObject implements AppMessage {
    public static final String TYPE = "peers_state_set";

    @JsonUnwrapped
    private JsonNode stateContent;

    @JsonCreator
    public SetPeerStateRequest(JsonNode stateContent) {
        this.stateContent = stateContent;
    }

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
