package ru.yandex.chemodan.app.telemost.appmessages.model.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.chemodan.app.telemost.appmessages.model.Source;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
public class SendCommandRequest extends DefaultObject implements AppMessage {
    public static final String TYPE = "send_command_request";

    @JsonProperty(value = "source", required = true)
    private final Source source;
    @JsonProperty(value = "command", required = true)
    private final Command command;

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
