package ru.yandex.chemodan.app.telemost.appmessages.model.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.chemodan.app.telemost.appmessages.AppMessage;
import ru.yandex.chemodan.app.telemost.appmessages.model.Source;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
public class EventMessage extends DefaultObject implements AppMessage {
    public static final String TYPE = "event_message";

    @JsonProperty(value = "source", required = true)
    private final Source source;
    @JsonProperty(value = "event", required = true)
    private final Event event;

    @Override
    public String getMessageType() {
        return TYPE;
    }
}
