package ru.yandex.chemodan.app.telemost.appmessages.sender;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.telemost.room.proto.MediatorOuterClass;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@RequiredArgsConstructor
public class MultipleDestinationMessageSender implements MessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MultipleDestinationMessageSender.class);
    private final ListF<MessageSender> senders;

    @Override
    public void sendAppMessage(String roomId, MediatorOuterClass.SendAppMessageRequest request) {
        for (MessageSender sender : senders) {
            sendMessageSafe(roomId, request, sender);
        }
    }

    private void sendMessageSafe(String roomId, MediatorOuterClass.SendAppMessageRequest request,
            MessageSender sender)
    {
        try {
            sender.sendAppMessage(roomId, request);
        } catch (Exception e) {
            logger.error("error received: {},", e.getMessage(), e);
        }
    }
}
