package ru.yandex.chemodan.app.telemost.bazinga;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.bazinga.task.TelemostTasksContextConfiguration;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;

@Configuration
@Import({
        TelemostTasksContextConfiguration.class,
        ChemodanBazingaWorkerContextConfiguration.class,
})
public class TelemostBazingaWorkerContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(TelemostTaskQueueNames.CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues() {
        return new BazingaWorkerTaskQueues(
                Option.of(TelemostTaskQueueNames.CRON),
                Option.of(TelemostTaskQueueNames.ONETIME),
                Option.empty(),
                Cf.list());
    }
}
