package ru.yandex.chemodan.app.telemost.bazinga.task;

import ru.yandex.chemodan.app.telemost.bazinga.TelemostTaskQueueNames;
import ru.yandex.chemodan.bazinga.TaskIdUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

public abstract class TelemostOnetimeTask<P> extends OnetimeTaskSupport<P> {

    public TelemostOnetimeTask(P parameters) {
        super(parameters);
    }

    public TelemostOnetimeTask(Class<P> parametersClass) {
        super(parametersClass);
    }

    @Override
    public TaskId id() {
        return TaskIdUtils.withSecondaryEnv(super.id());
    }

    @Override
    public TaskQueueName queueName() {
        return TelemostTaskQueueNames.ONETIME;
    }

    @Override
    public int priority() {
        return 0;
    }
}
