package ru.yandex.chemodan.app.telemost.chat;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.chat.model.Chat;
import ru.yandex.chemodan.app.telemost.chat.model.ChatHistory;
import ru.yandex.chemodan.app.telemost.chat.model.ChatRole;
import ru.yandex.chemodan.app.telemost.services.model.ChatType;

public interface ChatClient {

    Option<Chat> createChat(UUID chatId, ChatType chatType, String title, String description, Option<String> avatarId,
                            ListF<UUID> admins, ListF<UUID> members);

    Option<Chat> getChats(UUID chatId, ChatType chatType);

    Option<Chat> updateMembers(UUID chatId, ChatType chatType, ListF<UUID> addMembers, ListF<UUID> removeMembers,
                               ChatRole role);

    Option<UUID> getUser(String uid);

    MapF<String, UUID> getUsers(ListF<String> uids);

    Option<String> getUserUid(UUID user);

    boolean push(UUID chatId, ChatType chatType, UUID user, String message);

    Option<ChatHistory> history(UUID chatId, ChatType chatType, UUID user, Option<Long> offset);

    boolean chatIsEmpty(UUID chatId, ChatType chatType, UUID user);

    void removeChatMembers(UUID chatId, ChatType chatType);
}
