package ru.yandex.chemodan.app.telemost.chat.model;

import java.util.UUID;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@Getter
@AllArgsConstructor
public class ChatHistoryItem {
    private final Long timestamp;
    private final String displayName;
    private final UUID user;
    private final String message;

    private static final Logger logger = LoggerFactory.getLogger(ChatHistoryItem.class);

    public ChatHistoryItem(Long timestamp, String displayName, UUID user, JsonNode message) {
        this.timestamp = timestamp;
        this.displayName = displayName;
        this.user = user;

        // Form test message by type
        String textMessage = "";
        if (message.has("Plain")) {
            JsonNode plainMessage = message.get("Plain");
            if (plainMessage.has("Text")
                    && plainMessage.get("Text").has("MessageText")) {
                textMessage = plainMessage.get("Text").get("MessageText").asText();
            } else if (plainMessage.has("Gallery")
                    && plainMessage.get("Gallery").has("Text")) {
                textMessage = plainMessage.get("Gallery").get("Text").asText();
            } else {
                // TODO: убрать логирование сообщений истории чатов. Здесь логирование сделано для того,
                //  чтобы понять, что еще может быть тут полезным (например, цитирование и ответы)
                logger.info("Unrecognized chat history message Plain={}", message.get("Plain").toString());
            }
        } else if (message.has("SystemMessage")) {
            JsonNode systemMessage = message.get("SystemMessage");
            if (systemMessage.has("ChatCreatedInfo")) {
                textMessage = systemMessage.get("ChatCreatedInfo").get("InitialInfo").get("Name").asText();
            } else if (systemMessage.has("GenericMessage")) {
                textMessage = systemMessage.get("GenericMessage").get("MessageText").asText();
            }
        }
        this.message = textMessage;
    }

}
