package ru.yandex.chemodan.app.telemost.common;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Data
@AllArgsConstructor
@Builder
@BenderBindAllFields
public class ShardProperties {
    private int shardId;

    private boolean checkOverload;
    private boolean autoCalcCurrentParticipants;
    private int currentParticipants;
    private int maxParticipants;

    public static ShardProperties empty(int shardId) {
        return builder()
                .shardId(shardId)
                .checkOverload(false)
                .autoCalcCurrentParticipants(false)
                .currentParticipants(0)
                .maxParticipants(1000000)
                .build();
    }
}
