package ru.yandex.chemodan.app.telemost.common;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;

public class ShardPropertiesZkRegistry extends ZkRegistry<Integer, ShardProperties> {
    private final int currentShardId;

    public ShardPropertiesZkRegistry(ZkPath zkPath, int shardId) {
        super(zkPath, Bender.cons(ShardProperties.class), ShardProperties::getShardId, id -> Integer.toString(id));
        this.currentShardId = shardId;
    }

    public ShardProperties get() {
        return get(currentShardId);
    }

    public ShardProperties get(int shardId) {
        return getO(shardId).orElseGet(() -> ShardProperties.empty(shardId));
    }
}
