package ru.yandex.chemodan.app.telemost.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

@Configuration
@ConditionalOnMissingEmbeddedDb
public class TelemostDbContextConfiguration {

    @Bean
    @OverridableValuePrefix("telemost")
    public DataSourceProperties telemostDataSourceProperties() {
        return new DataSourceProperties();
    }
}
