package ru.yandex.chemodan.app.telemost.config;

import javax.sql.DataSource;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.chemodan.app.telemost.repository.dao.BroadcastDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ClientConfigurationDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceDtoDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferencePeerDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceStateDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceUserDao;
import ru.yandex.chemodan.app.telemost.repository.dao.MediaSessionDao;
import ru.yandex.chemodan.app.telemost.repository.dao.StreamDao;
import ru.yandex.chemodan.app.telemost.repository.dao.UserDao;
import ru.yandex.chemodan.app.telemost.repository.dao.UserStateDtoDao;
import ru.yandex.chemodan.app.telemost.repository.dao.UserTokenDtoDao;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.BroadcastPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.ClientConfigurationPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.ConferenceDtoPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.ConferencePeerPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.ConferenceStatePgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.ConferenceUserPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.MediaSessionPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.StreamPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.UserPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.UserStateDtoPgDaoImpl;
import ru.yandex.chemodan.app.telemost.repository.dao.impl.UserTokenDtoPgDaoImpl;
import ru.yandex.chemodan.app.telemost.services.BroadcastUriService;
import ru.yandex.chemodan.app.telemost.services.ChatParamsService;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.misc.db.postgres.PgBouncerFamiliarTransactionManager;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@Configuration
@Import({
        JdbcDatabaseConfiguratorContextConfiguration.class,
        TelemostDbContextConfiguration.class,
        JacksonContextConfiguration.class,
})
@EnableTransactionManagement
public class TelemostRepositoryContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    public TransactionTemplate transactionTemplate(PlatformTransactionManager transactionManager)
    {
        return new TransactionTemplate(transactionManager);
    }

    @Bean
    public JdbcDatabaseConfigurator telemostDbConfigurator(DataSourceProperties telemostDataSourceProperties)
    {
        return dbConfiguratorConfig.consJdbcConfigurator(telemostDataSourceProperties);
    }

    @Bean
    public DataSource telemostDataSource(JdbcDatabaseConfigurator telemostDbConfigurator)
    {
        return telemostDbConfigurator.configureDataSource();
    }

    @Bean
    public PgBouncerFamiliarTransactionManager txManager(DataSource psBullingDataSource)
    {
        return new PgBouncerFamiliarTransactionManager(psBullingDataSource);
    }

    @Bean
    public JdbcTemplate3 telemostJdbcTemplate(
            JdbcDatabaseConfigurator telemostDbConfigurator, DataSource telemostDataSource)
    {
        return telemostDbConfigurator.consTemplate(telemostDataSource);
    }

    @Bean
    public ConferenceDtoDao conferencePgDao(JdbcTemplate3 telemostJdbcTemplate)
    {
        return new ConferenceDtoPgDaoImpl(telemostJdbcTemplate);
    }

    @Bean
    public ConferencePeerDao conferencePeerDao(JdbcTemplate3 telemostJdbcTemplate)
    {
        return new ConferencePeerPgDaoImpl(telemostJdbcTemplate);
    }

    @Bean
    public UserTokenDtoDao userTokenDtoDao(JdbcTemplate3 telemostJdbcTemplate)
    {
        return new UserTokenDtoPgDaoImpl(telemostJdbcTemplate);
    }

    @Bean
    public ClientConfigurationDao clientConfigurationDao(JdbcTemplate3 jdbcTemplate3)
    {
        return new ClientConfigurationPgDaoImpl(jdbcTemplate3);
    }

    @Bean
    public ConferenceStateDao conferenceStateDao(JdbcTemplate3 jdbcTemplate3, BroadcastDao broadcastDao,
                                                 StreamDao streamDao)
    {
        return new ConferenceStatePgDaoImpl(jdbcTemplate3, broadcastDao, streamDao);
    }

    @Bean
    public ConferenceUserDao conferenceUserDao(JdbcTemplate3 jdbcTemplate3)
    {
        return new ConferenceUserPgDaoImpl(jdbcTemplate3);
    }

    @Bean
    public UserDao userDao(JdbcTemplate3 jdbcTemplate3)
    {
        return new UserPgDaoImpl(jdbcTemplate3);
    }

    @Bean
    public BroadcastDao broadcastDao(JdbcTemplate3 jdbcTemplate3, BroadcastUriService broadcastUriService,
                                     ChatParamsService chatParamsService)
    {
        return new BroadcastPgDaoImpl(jdbcTemplate3, broadcastUriService, chatParamsService);
    }

    @Bean
    public StreamDao streamDao(JdbcTemplate3 jdbcTemplate3,
                               @Value("${ugc-live.player-url}") String playerUrl)
    {
        return new StreamPgDaoImpl(jdbcTemplate3, playerUrl);
    }

    @Bean
    public UserStateDtoDao userStateDtoDao(JdbcTemplate3 jdbcTemplate3, ObjectMapper objectMapper)
    {
        return new UserStateDtoPgDaoImpl(jdbcTemplate3, objectMapper);
    }

    @Bean
    public MediaSessionDao mediaSessionDao(JdbcTemplate3 jdbcTemplate3)
    {
        return new MediaSessionPgDaoImpl(jdbcTemplate3);
    }
}
