package ru.yandex.chemodan.app.telemost.config;

import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.tanker.TankerClient;

@Configuration
public class TelemostTankerContextConfiguration {
    @Bean
    public TankerClient tankerClient(HttpClientConfigurator tankerHttpClientConfigurator,
                                     @Value("${tanker.host}") String host) {
        CloseableHttpClient httpClient = tankerHttpClientConfigurator.createBuilder().multiThreaded().build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "tanker");
        return new TankerClient(wrapped, host);
    }

    @Bean
    @OverridableValuePrefix("tanker")
    public HttpClientConfigurator tankerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
