package ru.yandex.chemodan.app.telemost.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.telemost.appmessages.AppMessageProcessor;
import ru.yandex.chemodan.app.telemost.config.common.TelemostBaseContextConfiguration;
import ru.yandex.chemodan.app.telemost.exceptions.ConferenceExceptionHandler;
import ru.yandex.chemodan.app.telemost.logging.TelemostAccessLog;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferencePeerDao;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceUserDao;
import ru.yandex.chemodan.app.telemost.repository.dao.UserDao;
import ru.yandex.chemodan.app.telemost.services.BroadcastService;
import ru.yandex.chemodan.app.telemost.services.ChatService;
import ru.yandex.chemodan.app.telemost.services.ClientConfigurationService;
import ru.yandex.chemodan.app.telemost.services.CommandService;
import ru.yandex.chemodan.app.telemost.services.ConferenceParticipantsService;
import ru.yandex.chemodan.app.telemost.services.ConferencePeerService;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.services.LimitsService;
import ru.yandex.chemodan.app.telemost.services.OverloadService;
import ru.yandex.chemodan.app.telemost.services.RoomService;
import ru.yandex.chemodan.app.telemost.services.StreamService;
import ru.yandex.chemodan.app.telemost.services.UserService;
import ru.yandex.chemodan.app.telemost.web.LoggingAnyExceptionHandler;
import ru.yandex.chemodan.app.telemost.web.converters.PassportOrYaTeamUidConverter;
import ru.yandex.chemodan.app.telemost.web.v1.actions.AuthorizationActions;
import ru.yandex.chemodan.app.telemost.web.v1.actions.ConferencesActions;
import ru.yandex.chemodan.app.telemost.web.v1.actions.JicofoActions;
import ru.yandex.chemodan.app.telemost.web.v2.actions.AppMessageActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.BillingActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.BroadcastsActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.ChatsActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.ConferencesActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.JicofoActionsV2;
import ru.yandex.chemodan.app.telemost.web.v2.actions.UsersActionsV2;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.MasterSlaveUnavailableExceptionHandler;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.chemodan.web.JacksonMapResultSerializer;
import ru.yandex.chemodan.web.JacksonPojoResultSerializer;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.parameter.bind.JacksonParameterBinder;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.HttpStatusCodeSourceExceptionHandler;
import ru.yandex.commune.a3.action.result.error.nested.ExceptionWithRootElementHandler;
import ru.yandex.commune.a3.security.SecurityExceptionHandler;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        A3JettyContextConfiguration.class,
        ZkTvm2ContextConfiguration.class,
        TelemostBaseContextConfiguration.class,
        TelemostServicesContextConfiguration.class,
        TelemostAppMessageConfiguration.class
})
public class TelemostWebActionsContextConfiguration {

    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration()
    {
        return new A3JettyConfiguration(Tuple2List.fromPairs("/*", "")) {
            @Override
            public void postConstruct(SingleWarJetty jetty, ActionApp actionApp) {
                jetty.setRequestLogFactory(TelemostAccessLog::new);
            }
        };
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo, ObjectMapper objectMapper)
    {
        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
                .addParameterBinders(Cf.list(new JacksonParameterBinder(objectMapper)))
                .setExceptionHandlers(Cf.list(new MasterSlaveUnavailableExceptionHandler(),
                        new HttpStatusCodeSourceExceptionHandler(),
                        new ExceptionWithRootElementHandler(),
                        new SecurityExceptionHandler(),
                        new A3ExceptionHandler(),
                        new ConferenceExceptionHandler(),
                        new LoggingAnyExceptionHandler()))
                .addResultSerializers(Cf.list(
                        new JacksonPojoResultSerializer(objectMapper), new JacksonMapResultSerializer(objectMapper)
                ))
                .addConverters(Cf.list(new PassportOrYaTeamUidConverter()));

        return configurator.configure();
    }

    @Bean
    public ConferencesActions conferencesActions(ConferenceService conferenceService,
                                                 @Qualifier("roomServiceAsyncV1") RoomService roomService,
                                                 ClientConfigurationService clientConfigurationService,
                                                 ConferencePeerService conferencePeerService,
                                                 LimitsService limitsService, UserService userService,
                                                 OverloadService overloadService)
    {
        return new ConferencesActions(conferenceService, roomService, clientConfigurationService, conferencePeerService,
                limitsService, userService, overloadService);
    }

    @Bean
    public ConferencesActionsV2 conferencesActionsV2(@Qualifier("roomServiceBlockingV2") RoomService roomService,
                                                     ConferenceParticipantsService conferenceParticipantsService,
                                                     ConferenceService conferenceService,
                                                     ClientConfigurationService clientConfigurationService,
                                                     ConferencePeerService conferencePeerService, LimitsService limitsService,
                                                     ChatService chatService, CommandService commandService, UserService userService,
                                                     ConferenceUserDao conferenceUserDao, ConferencePeerDao conferencePeerDao,
                                                     OverloadService overloadService)
    {
        return new ConferencesActionsV2(roomService, conferenceParticipantsService, conferenceService,
                clientConfigurationService, conferencePeerService, limitsService, chatService, commandService,
                userService, conferenceUserDao, conferencePeerDao, overloadService);
    }

    @Bean
    public AppMessageActionsV2 appMessageActionsV2(AppMessageProcessor appMessageProcessor)
    {
        return new AppMessageActionsV2(appMessageProcessor);
    }

    @Bean
    public BroadcastsActionsV2 broadcastActionsV2(ConferenceService conferenceService,
                                                  BroadcastService broadcastService,
                                                  StreamService streamService,
                                                  ChatService chatService,
                                                  UserService userService)
    {
        return new BroadcastsActionsV2(conferenceService, broadcastService, streamService, chatService, userService);
    }

    @Bean
    public UsersActionsV2 usersActionsV2(ConferencePeerService conferencePeerService, ConferenceService conferenceService)
    {
        return new UsersActionsV2(conferencePeerService, conferenceService);
    }

    @Bean
    public BillingActionsV2 billingActionsV2(UserDao userDao) {
        return new BillingActionsV2(userDao);
    }

    @Bean
    public JicofoActionsV2 jicofoActionsV2(@Qualifier("conferenceKeyService") ConferenceService conferenceService,
                                           ConferenceParticipantsService conferenceParticipantsService,
                                           ConferenceUserDao conferenceUserDao)
    {
        return new JicofoActionsV2(conferenceService, conferenceParticipantsService, conferenceUserDao);
    }

    @Bean
    public AuthorizationActions authorizationActions(ConferenceService conferenceService, UserService userService)
    {
        return new AuthorizationActions(conferenceService, userService);
    }

    @Bean
    public JicofoActions jicofoActions(ConferenceService conferenceService,
                                       @Qualifier("roomServiceBlockingV2") RoomService roomService)
    {
        return new JicofoActions(conferenceService, roomService);
    }

    @Bean
    public ChatsActionsV2 chatsActionsV2(ChatService chatService)
    {
        return new ChatsActionsV2(chatService);
    }
}
