package ru.yandex.chemodan.app.telemost.config.common;

import org.springframework.context.annotation.Bean;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.admin.ClientConfigurationAdminPage;
import ru.yandex.chemodan.app.telemost.admin.ShardPropertiesPage;
import ru.yandex.chemodan.app.telemost.common.ShardPropertiesZkRegistry;
import ru.yandex.chemodan.app.telemost.services.ClientConfigurationService;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.admin.web.AdminApp;

@ActionContainer
public class TelemostAdminPagesContextConfiguration {
    @Bean
    public ClientConfigurationAdminPage clientConfigurationAdminPage(AdminApp adminApp,
            ClientConfigurationService clientConfigurationService)
    {
        ClientConfigurationAdminPage clientConfigurationAdminPage = new ClientConfigurationAdminPage(clientConfigurationService);
        adminApp.registerAdminPage("Edit Actual Configuration", Option.of("Client Configuration"), clientConfigurationAdminPage);

        return clientConfigurationAdminPage;
    }

    @Bean
    public ShardPropertiesPage shardInfosPage(
            AdminApp adminApp,
            ShardPropertiesZkRegistry shardInfoZkRegistry
    ) {
        ShardPropertiesPage shardInfosPage = new ShardPropertiesPage(shardInfoZkRegistry);
        adminApp.registerAdminPage("Telemost shard properties", Option.of("Info"), shardInfosPage);

        return shardInfosPage;
    }
}
