package ru.yandex.chemodan.app.telemost.config.common;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.admin.idm.AppAccess;
import ru.yandex.chemodan.boot.admin.idm.AppsRegistry;
import ru.yandex.chemodan.boot.admin.idm.IdmAppsRegistryContextConfiguration;
import ru.yandex.chemodan.boot.admin.idm.IdmInterceptorConfig;
import ru.yandex.chemodan.boot.admin.idm.IdmInterceptorContextConfiguration;
import ru.yandex.misc.version.AppName;

@Configuration
@Import({
        TelemostBaseContextConfiguration.class,
        IdmInterceptorContextConfiguration.class,
        IdmAppsRegistryContextConfiguration.class
})
public class TelemostIdmInterceptorContextConfiguration {

    @Bean
    public IdmInterceptorConfig idmInterceptorConfig(AppName name, AppsRegistry registry) {
        Supplier<AppAccess> app = () -> registry.get(name).orElse(registry::getDefault).get();
        return new IdmInterceptorConfig(
                () -> app.get().getDefaultRoles(),
                path -> app
                        .get()
                        .getRoleMap()
                        .filterKeys(path::startsWith)
                        .values()
                        .reduceLeftO((a, b) -> Stream.of(a, b).flatMap(Set::stream).collect(Collectors.toSet()))
        );
    }
}
