package ru.yandex.chemodan.app.telemost.exceptions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandlerOrders;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.ExceptionUtils;

public class ConferenceExceptionHandler implements ExceptionHandler {
    @Override
    public Option<?> handleException(WebRequest request, ActionInvocationContext context,
                                     ExceptionResolver resolver, Exception exception) {
        if (exception instanceof ConferenceLinkNotComeException) {
            ConferenceLinkNotComeException e = (ConferenceLinkNotComeException) exception;
            context.getHttpContext().setStatusCode(e.getHttpStatusCode());
            return Option.of(new ErrorResult(e.getErrorName(), e.getExceptionData(),
                    Option.of(ExceptionUtils.getStackTrace(e)), Option.empty()));
        }
        return Option.empty();
    }

    @Override
    public int getOrder() {
        return ExceptionHandlerOrders.CUSTOM_EXCEPTION_HANDLER_ORDER;
    }
}
