package ru.yandex.chemodan.app.telemost.exceptions;

import org.joda.time.Instant;

import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.misc.io.http.HttpStatus;

public class ConferenceLinkNotComeException extends A3ExceptionWithStatus {

    private final Instant startEventTime;

    public ConferenceLinkNotComeException(Instant startEventTime) {
        super("ConferenceLinkNotCome", HttpStatus.SC_403_FORBIDDEN);
        this.startEventTime = startEventTime;
    }

    public String getExceptionData() {
        return "{\"start_event_time\": " + startEventTime.getMillis() / 1000 + "}";
    }

}
