package ru.yandex.chemodan.app.telemost.logging;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.chemodan.app.telemost.services.model.Conference;

@Slf4j
public class TelemostAuditLog {
    /**
     * this contract is used by automatic log greppers. do not change
     * @param conference - which conf to log
     */
    public void logConferenceCreated(Conference conference) {
        log.info("event=room_created, conferenceId={}, shortUrlIdSHA256={}, conference={}",
                conference.getRoomId(),
                conference.getShortUrlSHA256(),
                conference.getConferenceDto()
        );
    }
}
