package ru.yandex.chemodan.app.telemost.orchestrator;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.orchestrator.OrchestratorClient;
import ru.yandex.misc.ip.HostPort;

@AllArgsConstructor
public class TranslatorsOrchestratorImpl implements TranslatorsOrchestrator {

    private static final String GROUP_ID = "common";

    private final OrchestratorClient client;

    @Override
    public HostPort acquireTranslator(String sessionId) {
        return client.createSession(sessionId, GROUP_ID).getContainer();
    }

    @Override
    public void releaseTranslator(String sessionId) {
        client.finishSession(sessionId);
    }
}
