package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.BroadcastDto;

public interface BroadcastDao extends Dao<BroadcastDto, UUID> {
    void insertIfNotExists(BroadcastDto broadcast);

    BroadcastDto upsert(BroadcastDto broadcast);

    boolean updateUgcLiveLineIfNull(UUID broadcastId, long lineId);

    boolean updateBroadcastChatIdIfNull(UUID broadcastId, UUID broadcastChatId);

    Option<BroadcastDto> findByBroadcastId(UUID broadcastId);

    Option<BroadcastDto> findByBroadcastKey(String broadcastKey);

    Option<BroadcastDto> findByConferenceId(UUID conferenceId);
}
