package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.telemost.repository.model.ApiVersion;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceDto;

public interface ConferenceDtoDao extends Dao<ConferenceDto, UUID> {

    ConferenceDto insert(ConferenceDto conference);

    Option<ConferenceDto> findByConferenceId(String conferenceId);

    Option<ConferenceDto> findByShortUriIdO(String shortUriId);

    Option<ConferenceDto> findByBroadcastKeyO(String broadcastKey);

    SetF<ApiVersion> getConferencePeersVersions(String conferenceId);

    ConferenceDto addLinkToCalendarEvent(ConferenceDto conferenceDto, String eventId);
}
