package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.ApiVersion;
import ru.yandex.chemodan.app.telemost.repository.model.ConferencePeerDto;
import ru.yandex.chemodan.app.telemost.repository.model.UserByConferences;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;

public interface ConferencePeerDao extends Dao<ConferencePeerDto, UUID> {

    ConferencePeerDto mergeByPeerId(ConferencePeerDto userDto);

    ListF<ConferencePeerDto> findByConferenceAndUid(String conferenceId, PassportOrYaTeamUid uid);

    ListF<UserByConferences> findByUid(String uid);

    ListF<ConferencePeerDto> findPeersInConference(String conferenceId, ListF<String> userIds);

    ListF<ConferencePeerDto> findActivePeers(String conferenceId);

    ListF<ConferencePeerDto> findActiveOrMVP1Peers(String conferenceId);

    Option<ConferencePeerDto> findActiveMVP1Peer(UUID conferenceId, String peerId);

    ConferencePeerDto updateById(UUID id, String displayName, ApiVersion apiVersion);

    Option<ConferencePeerDto> findUserByConferenceAndUidAndClientInstanceId(UUID conferenceId, String clientInstanceId, Option<String> uid);

    default Option<ConferencePeerDto> findPeerInConference(String conferenceId, String userId) {
        return findPeersInConference(conferenceId, Cf.list(userId)).singleO();
    }
}
