package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceUserDto;
import ru.yandex.chemodan.app.telemost.repository.model.UserRole;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;

public interface ConferenceUserDao extends Dao<ConferenceUserDto, UUID> {
    void insertIfNotExists(UUID conferenceId, PassportOrYaTeamUid uid, UserRole role);

    ConferenceUserDto upsert(UUID conferenceId, PassportOrYaTeamUid uid, UserRole role);

    ListF<ConferenceUserDto> findByConference(UUID conferenceId);

    ListF<ConferenceUserDto> findByConferenceAndRole(UUID conferenceId, UserRole role);

    Option<ConferenceUserDto> findByConferenceAndUid(UUID conferenceId, PassportOrYaTeamUid uid);

    Option<ConferenceUserDto> findOwner(UUID conferenceId);

    MapF<String, ConferenceUserDto> findByConferenceAndPeers(UUID dbId, ListF<String> peerIds);
}
