package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.MediaSessionDto;
import ru.yandex.chemodan.app.telemost.repository.model.MediaSessionWithPeerTokenDto;

public interface MediaSessionDao extends Dao<MediaSessionDto, UUID> {

    int deactivateUsers(ListF<UUID> userIds);

    Option<MediaSessionDto> getActiveMediaSession(UUID conferenceId, String clientInstanceId, Option<String> uid);

    int deactivateSession(MediaSessionDto mediaSessionDto);

    Option<MediaSessionDto> insert(MediaSessionDto mediaSessionDto);

    Option<MediaSessionDto> tryToInsert(MediaSessionDto mediaSessionDto);

    Option<MediaSessionWithPeerTokenDto> getMediaSessionForUserAndConference(UUID conferenceId, String userId,
            String mediaSessionId);
}
