package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.StreamDto;

public interface StreamDao extends Dao<StreamDto, UUID> {

    public String getStreamUri(String ugcLiveSlug);

    Option<StreamDto> findActiveByBroadcastKey(String broadcastKey);

    StreamDto insert(StreamDto stream);

    Option<StreamDto> update(StreamDto stream);

    void delete(UUID streamId);

    ListF<StreamDto> getActiveStreams();
}
