package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.UserDto;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;

public interface UserDao extends Dao<UserDto, PassportOrYaTeamUid> {
    void insertIfNotExists(PassportOrYaTeamUid uid, boolean broadcastEnabled);

    UserDto upsert(PassportOrYaTeamUid uid, boolean broadcastEnabled);

    Option<UserDto> findByUid(PassportOrYaTeamUid uid);

    Option<UserDto> findByConferenceOwner(UUID conferenceId);
}
