package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.UserBackData;
import ru.yandex.chemodan.app.telemost.repository.model.UserStateDto;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;

public interface UserStateDtoDao extends Dao<UserStateDto, UUID> {

    Option<UserStateDto> updatePeerState(UUID userId, JsonNode state);

    MapF<String, UserStateDto> findStates(UUID conferenceId, ListF<String> peerIds);

    Option<UserStateDto> insertUserBackDataIntoState(UUID userId, UserBackData userData);

    void setPassportDataRequired(UUID id, boolean required);

    void setPassportDataRequiredByUid(PassportOrYaTeamUid uid, boolean required);

    ListF<UserStateDto> incrementVersion(ListF<UUID> userDataIds);
}
