package ru.yandex.chemodan.app.telemost.repository.dao;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.UserTokenDto;

public interface UserTokenDtoDao extends Dao<UserTokenDto, UUID> {

    UserTokenDto insert(UserTokenDto userTokenDto);

    Option<UserTokenDto> getActiveOrUpdateCreatedToken(UUID conferenceId, String uid, String token, long expireSeconds);

    Option<UserTokenDto> expireToken(UUID conferenceId, String token, long expirationSecond);

    Option<UserTokenDto> getToken(UUID conferenceId, String uid, String token, long expirationSecond);
}
