package ru.yandex.chemodan.app.telemost.repository.dao.impl;

import java.sql.ResultSet;

import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.dao.Dao;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public abstract class AbstractPgDao<T, U> implements Dao<T, U> {

    private JdbcTemplate3 jdbcTemplate;

    private final String findQuery;

    public AbstractPgDao(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.findQuery = new StringBuilder("SELECT ").append(getFieldsToSelect().mkString(", "))
                .append(" FROM ").append(getTableName())
                .append(" WHERE ").append(idFieldName()).append(" = ?").toString();
    }

    protected JdbcTemplate3 getJdbcTemplate() {
        return jdbcTemplate;
    }

    @Override
    public T findById(U id) {
        return jdbcTemplate.queryForObject(findQuery, (rs, rowNum) -> parseRow(rs), idToArg(id));
    }

    @Override
    public Option<T> findByIdO(U id) {
        return jdbcTemplate.queryForOption(findQuery, (rs, rowNum) -> parseRow(rs), idToArg(id));
    }

    @Override
    public void deleteAll() {
        jdbcTemplate.execute("DELETE FROM " + getTableName());
    }

    protected abstract String getTableName();

    protected abstract ListF<String> getFieldsToSelect();

    protected abstract T parseRow(ResultSet resultSet);

    protected String idFieldName() {
        return "id";
    }

    protected RowMapper<U> newIdMapper() {
        return (rs, num) -> idFromString(rs.getString(idFieldName()));
    }

    protected abstract U idFromString(String idString);

    protected Object idToArg(U id) {
        return id;
    }
}
