package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.web.v2.model.BroadcastStatus;
import ru.yandex.misc.lang.DefaultObject;

@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
public class BroadcastDto extends DefaultObject {
    private final Option<UUID> id;

    private final UUID conferenceId;

    private final String createdBy;

    private final String broadcastKey;

    private final Option<UUID> broadcastChatId;

    private final Option<String> caption;

    private final Option<String> description;

    private final Option<Long> ugcLiveLineId;

    // Эти поля формируются на основании значений, прочитанных в Dao
    private final String broadcastUri;
    private final Option<String> broadcastChatPath;
    private final BroadcastStatus status;

    public BroadcastDto(UUID conferenceId, String createdBy, String broadcastKey, Option<UUID> broadcastChatId,
                        Option<String> caption, Option<String> description) {
        this.conferenceId = conferenceId;
        this.createdBy = createdBy;
        this.broadcastKey = broadcastKey;
        this.broadcastChatId = broadcastChatId;
        this.caption = caption;
        this.description = description;

        this.id = Option.empty();
        this.ugcLiveLineId = Option.empty();

        this.broadcastUri = "";
        this.broadcastChatPath = Option.empty();
        this.status = BroadcastStatus.CREATED;
    }
}
