package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

@Data
public class ClientConfigurationDto {

    public static ClientConfigurationDto createActual(Instant createdAt, String createdBy, Option<String> comment, String value) {
        return new ClientConfigurationDto(Option.empty(), createdAt, createdBy, comment,  true, value);
    }

    private final Option<UUID> id;

    private final Instant createdAt;

    private final String createdBy;

    private final Option<String> comment;

    private final boolean actual;

    private final String value;

    public UUID getId() {
        return id.getOrThrow(IllegalStateException::new);
    }
}
