package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.calendar.model.CalendarEvent;
import ru.yandex.misc.lang.DefaultObject;

@EqualsAndHashCode(callSuper = true)
@Data
public class ConferenceDto extends DefaultObject {

    public static ConferenceDto create(String conferenceId, String conferencePassword, String limitType,
                                       Instant createdAt,
                                       String shortUrlId, Option<String> ownerUid, boolean staffOnly,
                                       boolean permanent, boolean yaTeam,
                                       Option<String> eventId) {
        return new ConferenceDto(Option.empty(), conferenceId, conferencePassword, limitType, createdAt, shortUrlId,
                ownerUid, staffOnly, permanent, yaTeam,
                // Calendar data
                eventId, Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    private final Option<UUID> id;

    private final String conferenceId;

    @ToString.Exclude
    private final String conferencePassword;

    private final String limitType;

    private final Instant createdAt;

    @ToString.Exclude
    private final String shortUrlId;

    @Deprecated
    /*
     * Legacy field for storing ownerUid. Always empty for new conferences.
     */
    private final Option<String> ownerUid;

    private final boolean staffOnly;

    private final boolean permanent;

    private final boolean yaTeam;

    private final Option<String> eventId;
    private final Option<String> eventCaption;
    private final Option<String> eventDescription;
    private final Option<Instant> startEvent;
    private final Option<Instant> endEvent;

    public UUID getId() {
        return id.getOrThrow(IllegalStateException::new);
    }

    public ConferenceDto withId(UUID id) {
        return new ConferenceDto(Option.of(id), this.conferenceId, this.conferencePassword, this.limitType,
                this.createdAt, this.shortUrlId, this.ownerUid, this.staffOnly, this.permanent, this.yaTeam,
                this.eventId, this.eventCaption, this.eventDescription, this.startEvent, this.endEvent);
    }

    public ConferenceDto withCalendarEventData(CalendarEvent calendarEvent) {
        return new ConferenceDto(this.id, this.conferenceId, this.conferencePassword, this.limitType, this.createdAt,
                this.shortUrlId, this.ownerUid, this.staffOnly, this.permanent, this.yaTeam,
                Option.of(calendarEvent.getEventId()), Option.of(calendarEvent.getEventCaption()),
                Option.of(calendarEvent.getEventDescription()),
                this.permanent ? Option.empty() : Option.of(calendarEvent.getStartEvent()),
                this.permanent ? Option.empty() : Option.of(calendarEvent.getEndEvent()));
    }

    public ConferenceDto withCalendarEventId(String eventId) {
        return new ConferenceDto(this.id, this.conferenceId, this.conferencePassword, this.limitType, this.createdAt,
                this.shortUrlId, this.ownerUid, this.staffOnly, this.permanent, this.yaTeam,
                Option.of(eventId), this.eventCaption, this.eventDescription, this.startEvent, this.endEvent);
    }

    public ConferenceDto withLimitType(String limitType) {
        return new ConferenceDto(this.id, this.conferenceId, this.conferencePassword, limitType, this.createdAt,
                this.shortUrlId, this.ownerUid, this.staffOnly, this.permanent, this.yaTeam,
                this.eventId, this.eventCaption, this.eventDescription, this.startEvent, this.endEvent);
    }
}
