package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.Data;

import ru.yandex.bolts.collection.Option;

@Data
public class ConferencePeerDto {

    private final Option<UUID> id;

    private final String peerId;

    private final Option<String> uid;

    private final UUID conferenceId;

    private final String displayName;

    private final Option<ApiVersion> apiVersion;

    private final Option<String> peerToken;

    public ConferencePeerDto withId(UUID id) {
        return new ConferencePeerDto(Option.of(id), this.peerId, this.uid, conferenceId, displayName, apiVersion, peerToken);
    }

    public UUID getId() {
        return id.getOrThrow(IllegalStateException::new);
    }

}
