package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.jackson.JodaTimeModule;
import ru.yandex.commune.json.jackson.ObjectMapperX;
import ru.yandex.commune.json.jackson.bolts.BoltsModule;
import ru.yandex.misc.lang.DefaultObject;

@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
public class ConferenceStateDto extends DefaultObject {
    private Option<UUID> id;
    private UUID conferenceId;
    private long version;

    private final boolean localRecordingAllowed;
    private final boolean cloudRecordingAllowed;
    private final boolean chatAllowed;
    private final boolean controlAllowed;
    private final boolean broadcastAllowed;
    private Option<String> chatPath;
    private final Option<BroadcastDto> broadcast;
    private final Option<StreamDto> stream;

    // Применяется только при чтении, берется из telemost.users.broadcast_enabled
    private boolean broadcastFeatureEnabled;

    private static final ObjectMapperX mapper = new ObjectMapperX(new ObjectMapper()
            .registerModule(new BoltsModule())
            .registerModule(new JodaTimeModule())
            .setSerializationInclusion(JsonInclude.Include.NON_NULL));

    public ConferenceStateDto(boolean localRecordingAllowed, boolean cloudRecordingAllowed,
                              boolean chatAllowed, Option<String> chatPath, boolean controlAllowed,
                              boolean broadcastAllowed, boolean broadcastFeatureEnabled,
                              Option<BroadcastDto> broadcast, Option<StreamDto> stream, UUID conferenceId) {
        this.conferenceId = conferenceId;
        this.version = 0L;

        this.localRecordingAllowed = localRecordingAllowed;
        this.cloudRecordingAllowed = cloudRecordingAllowed;
        this.chatAllowed = chatAllowed;
        this.chatPath = chatPath;
        this.controlAllowed = controlAllowed;
        this.broadcastAllowed = broadcastAllowed;
        this.broadcastFeatureEnabled = broadcastFeatureEnabled;
        this.broadcast = broadcast;
        this.stream = stream;
    }

    public UUID getId() {
        return id.getOrThrow(IllegalStateException::new);
    }

}
