package ru.yandex.chemodan.app.telemost.repository.model;

/* Это вспомогательный класс для чтения/записи части стейта конференции в Dao, которая хранится в jsonb.
 * По-хорошему, поля из него надо разнести на отдельные поля таблицы и избавиться от этого класса.
 */

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.jackson.JodaTimeModule;
import ru.yandex.commune.json.jackson.ObjectMapperX;
import ru.yandex.commune.json.jackson.bolts.BoltsModule;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceStateNode extends DefaultObject {
    private static final ObjectMapperX mapper = new ObjectMapperX(new ObjectMapper()
            .registerModule(new BoltsModule())
            .registerModule(new JodaTimeModule())
            .setSerializationInclusion(JsonInclude.Include.NON_NULL));

    @JsonProperty("local_recording_allowed")
    private boolean localRecordingAllowed;

    @JsonProperty("cloud_recording_allowed")
    private boolean cloudRecordingAllowed;

    @JsonProperty("chat_allowed")
    private boolean chatAllowed;

    @JsonProperty("control_allowed")
    private boolean controlAllowed;

    @JsonProperty("chat_path")
    private Option<String> chatPath;

    public ConferenceStateNode(ConferenceStateDto state) {
        this.localRecordingAllowed = state.isLocalRecordingAllowed();
        this.cloudRecordingAllowed = state.isCloudRecordingAllowed();
        this.chatAllowed = state.isChatAllowed();
        this.controlAllowed = state.isControlAllowed();
        this.chatPath = state.getChatPath();
    }

    public static ConferenceStateNode fromString(String str) {
        return mapper.readValue(ConferenceStateNode.class, str);
    }

    public String asString() {
        return mapper.writeValueAsString(this);
    }
}
