package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.Data;
import lombok.ToString;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

@Data
@ToString(doNotUseGetters = true)
public class MediaSessionDto {

    public static final String MVP1_DEACTIVATING_SESSION_ID = "MVP1-DEACTIVATED";

    // Date and time (GMT): Tuesday, 1 January 1901 г., 0:00:00
    public static final Instant ACTIVE_SESSION_INSTANT = new Instant(-2177452800000L);

    public static MediaSessionDto createActiveForInsert(String mediaSessionId, UUID userId, Option<String> clientInstanceId) {
        return new MediaSessionDto(Option.empty(), mediaSessionId, userId, ACTIVE_SESSION_INSTANT, clientInstanceId);
    }

    public static MediaSessionDto createDeactivatingMVP1Session(UUID userId) {
        return new MediaSessionDto(Option.empty(), MVP1_DEACTIVATING_SESSION_ID, userId, Instant.now(), Option.empty());
    }

    private final Option<UUID> id;

    private final String mediaSessionId;

    private final UUID userId;

    private final Instant disconnectedAt;

    private final Option<String> clientInstanceId;

    public MediaSessionDto withId(UUID id) {
        return new MediaSessionDto(Option.of(id), this.mediaSessionId, this.userId, this.disconnectedAt,
                this.clientInstanceId);
    }

    public MediaSessionDto newActiveSession(String mediaSessionId) {
        return new MediaSessionDto(this.id, mediaSessionId, this.userId, ACTIVE_SESSION_INSTANT, this.clientInstanceId);
    }

    public UUID getId() {
        return this.id.getOrThrow(IllegalStateException::new);
    }

    public boolean isActive() {
        return ACTIVE_SESSION_INSTANT.equals(disconnectedAt);
    }
}
