package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.With;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

@EqualsAndHashCode(callSuper = true)
@Data
@With
@AllArgsConstructor
public class StreamDto extends DefaultObject {
    private final UUID id;

    private final UUID broadcastId;

    private final String ugcLiveSlug;

    private final Option<String> ownerUid;

    private final Option<Instant> startedAt;

    private final Option<Instant> stoppedAt;

    private final Option<String> translator;

    private final Option<String> translatorToken;

    private final Option<String> rtmpKey;

    private final Option<Instant> translatorLastKeepAlive;

    private final Option<String> translatorPeerId;

    // Вычисляемое поле
    private final String streamUri;

    public StreamDto(StreamDto basicStream, Option<String> translatorPeerId) {
        this.id = basicStream.getId();
        this.broadcastId = basicStream.getBroadcastId();
        this.ugcLiveSlug = basicStream.getUgcLiveSlug();
        this.ownerUid = basicStream.getOwnerUid();
        this.startedAt = basicStream.getStartedAt();

        this.stoppedAt = basicStream.getStoppedAt();
        this.translator = basicStream.getTranslator();
        this.translatorToken = basicStream.getTranslatorToken();
        this.rtmpKey = basicStream.getRtmpKey();
        this.translatorLastKeepAlive = basicStream.getTranslatorLastKeepAlive();
        this.translatorPeerId = translatorPeerId;

        this.streamUri = basicStream.getStreamUri();
    }

}
