package ru.yandex.chemodan.app.telemost.repository.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.User;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class UserBackData extends DefaultObject implements JacksonPojo {
    @JsonProperty("uid")
    private Option<String> uid;

    @JsonProperty("display_name")
    private Option<String> displayName;

    @JsonProperty("avatar_url")
    private Option<String> avatarUrl;

    @JsonProperty("is_default_avatar")
    private Option<Boolean> isDefaultAvatar;

    @JsonProperty("role")
    private Option<UserRole> role;

    public UserBackData(User user, Option<UserRole> role) {
        this(Option.of(user.getUid().asString()), user.getDisplayName(), user.getAvatarUrl(), user.getIsDefaultAvatar(), role);
    }

    public UserBackData(User user) {
        this(user, Option.empty());
    }
}
