package ru.yandex.chemodan.app.telemost.repository.model;

import ru.yandex.chemodan.app.telemost.chat.model.ChatRole;

public enum UserRole {

    ADMIN(ChatRole.ADMIN),
    OWNER(ChatRole.ADMIN),
    MEMBER(ChatRole.MEMBER);

    private final ChatRole chatRole;

    UserRole(ChatRole chatRole) {
        this.chatRole = chatRole;
    }

    public boolean isAdmin() {
        return this == ADMIN || this == OWNER;
    }

    public ChatRole getChatRole() {
        return chatRole;
    }
}
