package ru.yandex.chemodan.app.telemost.repository.model;

import java.util.UUID;

import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

@Data
public class UserTokenDto {

    private final Option<UUID> id;

    private final Option<String> uid;

    private final UUID conferenceId;

    private final String token;

    private final Instant createdAt;

    private final String status;

    public UserTokenDto withId(UUID id) {
        return new UserTokenDto(Option.of(id), this.uid, this.conferenceId, this.token, this.createdAt, this.status);
    }
}
