package ru.yandex.chemodan.app.telemost.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

import ru.yandex.chemodan.app.telemost.exceptions.BadUriTelemostException;
import ru.yandex.chemodan.app.telemost.services.model.BroadcastUriData;

public class BroadcastUriService {
    private final Pattern keyUrlIdPattern;

    private final String urlTemplate;

    private final String uriHost;

    public BroadcastUriService(
            String broadcastUriPattern,
            String urlTemplate,
            String uriHost)
    {
        this.keyUrlIdPattern = Pattern.compile(broadcastUriPattern);
        this.urlTemplate = urlTemplate;
        this.uriHost = uriHost;
    }

    public BroadcastUriData getBroadcastUriData(String broadcastUri) {
        return getBroadcastUriData(broadcastUri, keyUrlIdPattern);
    }

    public String buildBroadcastUrl(String broadcastKey) {
        return String.format(urlTemplate, uriHost, broadcastKey);
    }

    private BroadcastUriData getBroadcastUriData(String broadcastUri, Pattern pattern) {
        if (!pattern.matcher(broadcastUri).matches()) {
            throw new BadUriTelemostException(String.format("Bad broadcast uri format '%s'", broadcastUri));
        }
        URI uri = createUri(broadcastUri);
        String path = uri.getPath();
        String broadcastKey = path.substring(path.lastIndexOf("/") + 1);
        return new BroadcastUriData(broadcastKey);
    }

    private URI createUri(String broadcastUri) {
        try {
            return new URI(broadcastUri);
        } catch (URISyntaxException e) {
            throw new BadUriTelemostException(String.format("Cannot parse the broadcast uri '%s'", broadcastUri));
        }
    }
}
