package ru.yandex.chemodan.app.telemost.services;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.ChatType;

@AllArgsConstructor
public class ChatParamsService {

    private final String chatTypeId;

    private final String chatConferenceNamespaceId;
    private final boolean chatConferenceIsPublic;
    private final String chatBroadcastNamespaceId;
    private final boolean chatBroadcastIsPublic;

    public String chatPath(UUID chatId, ChatType chatType) {
        return chatTypeId + "/" + getNamespaceId(chatType) + "/" + chatId.toString();
    }

    public Option<String> chatPath(Option<UUID> chatId, ChatType chatType) {
        return chatId.map(x -> chatPath(x, chatType));
    }

    public String getNamespaceId(ChatType chatType) {
        return chatType == ChatType.CONFERENCE ? chatConferenceNamespaceId : chatBroadcastNamespaceId;
    }

    public boolean isPublic(ChatType chatType) {
        return chatType == ChatType.CONFERENCE ? chatConferenceIsPublic : chatBroadcastIsPublic;
    }

}
