package ru.yandex.chemodan.app.telemost.services;

import java.util.function.Supplier;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceDto;
import ru.yandex.chemodan.app.telemost.services.model.ConferenceClientParameters;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.app.telemost.services.model.User;

public class DefaultConferenceCreator implements ConferenceCreator {

    private final Supplier<String> conferencePasswordProvider;

    private final ConferenceUriService conferenceUriService;

    public DefaultConferenceCreator(Supplier<String> conferencePasswordProvider,
            ConferenceUriService conferenceUriService)
    {
        this.conferencePasswordProvider = conferencePasswordProvider;
        this.conferenceUriService = conferenceUriService;
    }

    @Override
    public ConferenceDto createConferenceDto(String conferenceId, ConferenceClientParameters clientParameters) {
        boolean isPermanent = clientParameters.getPermanent().getOrElse(this::getDefaultIsPermanentValue);
        boolean isStaffOnly = clientParameters.getStaffOnly().getOrElse(Boolean.FALSE);

        return ConferenceDto.create(conferenceId, conferencePasswordProvider.get(),
                clientParameters.getLimitType().name(), Instant.now(),
                conferenceUriService.createShortUrlId(isPermanent),
                Option.empty(), isStaffOnly, isPermanent, isYaTeam(),
                clientParameters.getEventId()
        );
    }

    @Override
    public boolean isAcceptableFor(ConferenceClientParameters clientParameters) {
        return clientParameters.getUser().map(User::getUid).map(PassportOrYaTeamUid::isPassportUid).getOrElse(Boolean.TRUE) ||
                clientParameters.getExternalMeeting().getOrElse(Boolean.FALSE);
    }

    protected Boolean getDefaultIsPermanentValue() {
        return Boolean.FALSE;
    }


    protected boolean isYaTeam() {
        return false;
    }
}
