package ru.yandex.chemodan.app.telemost.services;

import java.util.UUID;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.common.ShardProperties;
import ru.yandex.chemodan.app.telemost.common.ShardPropertiesZkRegistry;
import ru.yandex.chemodan.app.telemost.exceptions.TelemostOverloadException;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceUserDao;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceDto;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;

@AllArgsConstructor
public class OverloadService {
    private ShardPropertiesZkRegistry shardPropertiesZkRegistry;
    private ConferenceUserDao conferenceUserDao;
    private ConferenceService conferenceService;
    private ConferenceUriService conferenceUriService;

    public void checkOverload() {
        if (isOverload()) {
            throw new TelemostOverloadException();
        }
    }

    public void checkOverload(UUID conferenceId, Option<PassportOrYaTeamUid> uid) {
        if (isOverload() && uid.flatMap(u -> conferenceUserDao.findByConferenceAndUid(conferenceId, u)).isEmpty()) {
            throw new TelemostOverloadException();
        }
    }

    public void checkOverload(String conferenceUri, Option<PassportOrYaTeamUid> uid) {
        Option<ConferenceDto> conference = conferenceService.findConferenceByUriId(
                conferenceUriService.getConferenceUriData(conferenceUri).getShortUrlId()
        );
        conference.ifPresent(c -> checkOverload(c.getId(), uid));
    }

    private boolean isOverload() {
        ShardProperties shardProperties = shardPropertiesZkRegistry.get();
        return shardProperties.isCheckOverload() && shardProperties.getCurrentParticipants() >= shardProperties.getMaxParticipants();
    }
}
