package ru.yandex.chemodan.app.telemost.services;

import java.util.UUID;

import org.apache.commons.codec.digest.DigestUtils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.Conference;

public class ParticipantIdGenerator {

    public String createParticipantId(Conference conference, Option<String> clientInstanceIdO, Option<String> uid) {
        if (!clientInstanceIdO.isPresent()) {
            return UUID.randomUUID().toString();
        }
        String participantKey = conference.getRoomId() + clientInstanceIdO.get() + uid.getOrElse("");
        return DigestUtils.md5Hex(participantKey);
    }
}
