package ru.yandex.chemodan.app.telemost.services;

import ru.yandex.commune.dynproperties.DynamicProperty;

public class PropertyManagerImpl implements PropertyManager {

    private final DynamicProperty<Long> conferenceTtl =
            new DynamicProperty<>("telemost-conferences-ttl-secs", DEFAULT_CONFERENCE_TTL_SECS);

    private final DynamicProperty<Long> conferenceTbl =
            new DynamicProperty<>("telemost-conferences-tbl-secs", DEFAULT_CONFERENCE_TBL_SECS);

    private final DynamicProperty<Boolean> useCloudRecordingAllowed =
            new DynamicProperty<>("telemost.use-cloud-recording-allowed", false);

    private final DynamicProperty<Boolean> useNonYaTeamChatsAllowed =
            new DynamicProperty<>("telemost.use-non-ya-team-chats-allowed", false);

    private final DynamicProperty<Boolean> useYaTeamChatsAllowed =
            new DynamicProperty<>("telemost.use-ya-team-chats-allowed", false);

    private final DynamicProperty<Boolean> useNonYaTeamControlAllowed =
            new DynamicProperty<>("telemost.use-non-ya-team-control-allowed", false);

    private final DynamicProperty<Boolean> useYaTeamControlAllowed =
            new DynamicProperty<>("telemost.use-ya-team-control-allowed", false);

    private final DynamicProperty<Boolean> useNonYaTeamBroadcastAllowed =
            new DynamicProperty<>("telemost.use-non-ya-team-broadcast-allowed", false);

    private final DynamicProperty<Boolean> useYaTeamBroadcastAllowed =
            new DynamicProperty<>("telemost.use-ya-team-broadcast-allowed", false);

    @Override
    public Long getConferenceTtl() {
        return conferenceTtl.get();
    }

    @Override
    public Long getConferenceTbl() {
        return conferenceTbl.get();
    }

    @Override
    public boolean getUseLocalRecordingAllowed() {
        return true;
    }

    @Override
    public boolean getUseCloudRecordingAllowed() {
        return useCloudRecordingAllowed.get();
    }

    @Override
    public boolean getUseNonYaTeamChatsAllowed() {
        return useNonYaTeamChatsAllowed.get();
    }

    @Override
    public boolean getUseYaTeamChatsAllowed() {
        return useYaTeamChatsAllowed.get();
    }

    @Override
    public boolean getUseNonYaTeamControlAllowed() {
        return useNonYaTeamControlAllowed.get();
    }

    @Override
    public boolean getUseYaTeamControlAllowed() {
        return useYaTeamControlAllowed.get();
    }

    @Override
    public boolean getUseNonYaTeamBroadcastAllowed() {
        return useNonYaTeamBroadcastAllowed.get();
    }

    @Override
    public boolean getUseYaTeamBroadcastAllowed() {
        return useYaTeamBroadcastAllowed.get();
    }
}
