package ru.yandex.chemodan.app.telemost.services;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUser;
import ru.yandex.chemodan.zk.registries.staff.YandexStaffUserRegistry;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class StaffService {
    private static final Logger logger = LoggerFactory.getLogger(StaffService.class);

    private final YandexStaffUserRegistry staffRegistry;

    public StaffService(YandexStaffUserRegistry staffRegistry) {
        this.staffRegistry = staffRegistry;
    }

    public Option<PassportUid> resolveUid(String yaTeamUid) {
        PassportUid internalUid = PassportUid.cons(Long.parseLong(yaTeamUid.substring(3)));
        Option<PassportUid> externalUid = staffRegistry.findByInternalUid(internalUid)
                .map(YandexStaffUser::getExternalUid);
        logger.info("Mapping internal uid={} on external uid={}", yaTeamUid, externalUid);
        return externalUid;
    }

    public Option<PassportUid> resolveUid(Option<PassportOrYaTeamUid> uidO) {
        if (!uidO.isPresent()) {
            return Option.empty();
        }
        if (uidO.get().isPassportUid()) {
            return Option.of(uidO.get().getPassportUid());
        }
        return resolveUid(uidO.get().asString());
    }
}
