package ru.yandex.chemodan.app.telemost.services;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.ugcLive.UgcLiveClient;
import ru.yandex.chemodan.app.telemost.ugcLive.UgcLiveStreamPublisher;
import ru.yandex.chemodan.app.telemost.ugcLive.model.StreamAction;
import ru.yandex.chemodan.app.telemost.ugcLive.model.StreamState;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@AllArgsConstructor
public class UgcLiveService {
    private static final Logger logger = LoggerFactory.getLogger(UgcLiveService.class);

    private final UgcLiveClient ugcLiveClient;
    private final UgcLiveStreamPublisher ugcLiveStreamPublisher;

    public void submitStreamPublishing(String episodeSlug) {
        ugcLiveStreamPublisher.submitPublishing(episodeSlug);
    }

    public void stopOrCancelAndDeleteStream(String episodeSlug) {
        Option<StreamState> state = ugcLiveClient.getStreamState(episodeSlug);

        Option<StreamAction> action = state.flatMapO(s ->
                s.getApplicableActions().find(a -> a == StreamAction.STOP || a == StreamAction.CANCEL));

        logger.info("Stream {} state now is {} so performing {} before delete it",
                episodeSlug, state.orElse((StreamState) null), action.orElse((StreamAction) null));

        action.ifPresent(a -> ugcLiveClient.performStreamAction(episodeSlug, a));
        state.ifPresent(s -> ugcLiveClient.deleteEpisode(episodeSlug));
    }
}
