package ru.yandex.chemodan.app.telemost.services;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.dao.UserDao;
import ru.yandex.chemodan.app.telemost.repository.model.UserDto;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@AllArgsConstructor
public class UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);

    private final int insertUserRetryCount;
    private final UserDao userDao;
    private final StaffService staffService;

    public void addUserIfNotExists(PassportOrYaTeamUid uid, boolean broadcastEnabled) {
        // For ya-team uid also add linked staff user as conference admin
        RetryUtils.retry(logger, insertUserRetryCount, () -> {
            userDao.insertIfNotExists(uid, broadcastEnabled);
            if (uid.isYaTeamUid()) {
                staffService.resolveUid(Option.of(uid))
                        .map(PassportOrYaTeamUid::passportUid)
                        .ifPresent(staff -> userDao.insertIfNotExists(staff, broadcastEnabled));
            }
        });
    }

    public void addUserIfNotExists(PassportOrYaTeamUid uid) {
        addUserIfNotExists(uid, false);
    }

    public UserDto upsert(PassportOrYaTeamUid uid, boolean broadcastEnabled) {
        return RetryUtils.retry(logger, insertUserRetryCount, () -> userDao.upsert(uid, broadcastEnabled));
    }

    public Option<UserDto> findByUid(PassportOrYaTeamUid uid) {
        return userDao.findByUid(uid);
    }
}
